<?php

if ($_SERVER['HTTP_HOST'] === 'openqr.in') {
    require_once('dbserver.php');
} else {
    require_once('db2.php');
}

// फाइल अपलोड की सीमा बढ़ाएं
ini_set('upload_max_filesize', '256M');
ini_set('post_max_size', '256M');
ini_set('memory_limit', '256M');
ini_set('max_execution_time', 300);
ini_set('max_input_time', 300);

// डीबग लॉगिंग के लिए
ini_set('display_errors', 1);
error_reporting(E_ALL);
error_log("स्क्रिप्ट शुरू हुई");

// फॉर्म सबमिशन को संभालें
header('Content-Type: application/json');

try {
    // Validate POST data
    $requiredFields = ['name', 'usermobile', 'userimage', 'userimagefilename', 'qrimage', 'qrcodefilename'];
    foreach ($requiredFields as $field) {
        if (!isset($_POST[$field])) {
            throw new Exception('Required data missing');
        }
    }

    // Debugging: Save base64 image data to files
    if (isset($_POST['userimage'])) {
        $base64_string = $_POST['userimage'];
        file_put_contents("userimagedebug_base64.txt", $base64_string); // Debugging के लिए फाइल में सेव करें
    }
    if (isset($_POST['qrimage'])) {
        $base64_string = $_POST['qrimage'];
        file_put_contents("qrimagedebug_base64.txt", $base64_string); // Debugging के लिए फाइल में सेव करें
    }

    // Save to database
    $trackingId = saveFormData($_POST);

    // Process and save user image
    saveImage($_POST['userimage'], $_POST['userimagefilename'], 'user_images');

    // Process and save QR code
    saveImage($_POST['qrimage'], $_POST['qrcodefilename'], 'qrcode');

    // Generate card
    $cardFilename = generateCard($_POST, $_POST['userimagefilename'], $_POST['qrcodefilename']);
    
    echo json_encode([
        'success' => true,
        'newcard_image' => $cardFilename
    ]);
    
} catch (Exception $e) {
    error_log("Form submission error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}

function saveFormData($data) {
    global $conn;

    $mobile = $data['usermobile'];
    $datetime = date('YmdHis');
    $trackingId = $mobile . $datetime;

    $stmt = $conn->prepare("INSERT INTO kumbh (name, usermobile, emname, emmobile, pincode, state, 
                          gender, age, fulladdress, dateofyatra, usercardimagefilename, 
                          qrcodefilename, cardstatus, trackingid, dateofupload, qrcodeurl) 
                          VALUES (?,?,?,?,?,?,?,?,?,?,?,?,'pending',?,NOW(),?)");
    
    $qrUrl = 'https://openqr.in/kumbh/index.html?id=' . $mobile;
    
    $stmt->bind_param("ssssssssssssss", 
        $data['name'],
        $data['usermobile'],
        $data['emname'],
        $data['emmobile'],
        $data['pincode'],
        $data['state'],
        $data['gender'],
        $data['age'],
        $data['fulladdress'],
        $data['dateofyatra'],
        $data['userimagefilename'],
        $data['qrcodefilename'],
        $trackingId,
        $qrUrl
    );

    if (!$stmt->execute()) {
        throw new Exception("Database error: " . $stmt->error);
    }

    return $trackingId;
}

function saveImage($base64Image, $filename, $folder) {
    // डायरेक्टरी पथ को सही करें
    $directories = [
        dirname(__FILE__) . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR
    ];
    
    // लॉग करें कि कहाँ सेव हो रहा है
    error_log("सेव करने का पथ: " . $directories[0]);
    
    foreach ($directories as $dir) {
        if (!file_exists($dir)) {
            if (!mkdir($dir, 0777, true)) {
                error_log("डायरेक्टरी नहीं बना सका: " . $dir);
                throw new Exception("डायरेक्टरी नहीं बना सका: " . $dir);
            }
            chmod($dir, 0777);
        }
    }

    // बेस64 डेटा की जांच करें
    if (empty($base64Image)) {
        error_log("खाली इमेज डेटा मिला");
        throw new Exception("इमेज डेटा खाली है");
    }

    // बेस64 डेटा को साफ करें
    $imageData = str_replace(['data:image/jpeg;base64,', 'data:image/png;base64,', 'data:image/jpg;base64,'], '', $base64Image);
    $imageData = base64_decode($imageData);
    
    if ($imageData === false) {
        error_log("बेस64 डीकोड में त्रुटि");
        throw new Exception("इमेज डेटा सही फॉर्मेट में नहीं है");
    }

    $fullPath = $directories[0] . $filename;
    if (file_put_contents($fullPath, $imageData) === false) {
        error_log("फाइल लिखने में त्रुटि: " . $fullPath);
        throw new Exception("फाइल नहीं लिख सका: " . $fullPath);
    }
    
    // फाइल परमिशन सेट करें
    chmod($fullPath, 0666);
    error_log("फाइल सफलतापूर्वक सेव हुई: " . $fullPath);
}

function generateCard($data, $userImageFilename, $qrCodeFilename) {
    $card_dir = dirname(__FILE__) . '/card_images/';
    
    // Load template
    $template_url = 'https://openqr.in/kumbh/cardteplate.jpg';
    $template = imagecreatefromjpeg($template_url);
    
    // Load user image - now using imagecreatefromstring for flexibility
    $userImagePath = dirname(__FILE__) . '/user_images/' . $userImageFilename;
    $userImage = imagecreatefromstring(file_get_contents($userImagePath));
    if (!$userImage) {
        throw new Exception("Could not load user image");
    }
    
    // Load QR code - now using imagecreatefromstring for flexibility
    $qrPath = dirname(__FILE__) . '/qrcode/' . $qrCodeFilename;
    $qrCode = imagecreatefromstring(file_get_contents($qrPath));
    if (!$qrCode) {
        throw new Exception("Could not load QR code");
    }
    
    // Add images to template
    imagecopyresampled($template, $userImage, 40, 199, 0, 0, 200, 250, imagesx($userImage), imagesy($userImage));
    imagecopyresampled($template, $qrCode, imagesx($template)-250, 235, 0, 0, 200, 200, imagesx($qrCode), imagesy($qrCode));
    
    // Save card
    $cardFilename = 'card_' . $data['trackingid'] . '.jpg';
    imagejpeg($template, $card_dir . $cardFilename, 90);
    
    // Cleanup
    imagedestroy($template);
    imagedestroy($userImage);
    imagedestroy($qrCode);
    
    return $cardFilename;
}
?>